import estructura
from Modulo_lista import *

#P1

#a
estructura.crear("Pais", "nombre continente habitantes")
paisHolanda = Pais("Holanda", "Europa", 120000)

#b
estructura.mutable("PaisMut", "nombre continente habitantes")
paisAlemania = PaisMut("Alemania", "Europa", 140000)

#c
#cambiarHabitantes: Pais int -> Pais
def cambiarHabitantes(pais, cantHabitantes):
	pais = Pais(pais.nombre, pais.continente, cantHabitantes)
	return pais

assert cambiarHabitantes(paisHolanda, 200000).habitantes == 200000

#d
#cambiarHabitantesMut: PaisMut int -> PaisMut
def cambiarHabitantesMut(pais, cantHabitantes):
	pais.habitantes = cantHabitantes
	return pais

assert cambiarHabitantesMut(paisAlemania, 300000).habitantes == 300000

#e
#cantidadHabitantes: Pais/PaisMut -> int
def cantidadHabitantes(pais):
	return pais.habitantes

assert cantidadHabitantes(paisHolanda) == 120000
assert cantidadHabitantes(paisAlemania) == 300000

#P2

#a
paisColombia = PaisMut("Colombia", "America", 400000)
paisIndia = PaisMut("India", "Asia", 600000)
listaPaises = lista(paisAlemania, lista(paisColombia, None))
listaPaisesIndex = [paisAlemania, paisColombia]

#consideraremos que el nuevo pais debe ser agregado al inicio de la lista

#agregarPais: PaisMut lista -> lista
def agregarPais(pais, l):
	return lista(pais, l)

assert agregarPais(paisIndia, listaPaises) == lista(paisIndia, lista(paisAlemania, lista(paisColombia, None)))

#agregarPaisIndex:  PaisMut list -> list
def agregarPaisIndex(pais, l):
	l.insert(0,pais)
	#tambien funcionaria:
	#ln = [pais]
	#return ln + l
	return l

assert agregarPaisIndex(paisIndia, listaPaisesIndex) == [paisIndia, paisAlemania, paisColombia]

#b
#quitarPais: PaisMut lista -> lista
def quitarPais(pais, l):
	if l == None:
		return l
	elif cabeza(l) == pais:
		return cola(l)
	else:
		return lista(cabeza(l), quitarPais(pais, cola(l)))

assert quitarPais(paisColombia, listaPaises) == lista(paisAlemania, None)

#quitarPais: PaisMut list -> list
def quitarPaisIndex(pais, l):
	if pais in l:
		l.remove(pais)
	return l

assert quitarPaisIndex(paisColombia, listaPaisesIndex) == [paisIndia, paisAlemania]	

#c
#poblacionMundial: lista -> int
def poblacionMundial(l, habitantes = 0):
	if l == None:
		return habitantes
	else:
		habitantes += cabeza(l).habitantes
		return poblacionMundial(cola(l), habitantes)

assert poblacionMundial(listaPaises) == 700000

#poblacionMundialIndex: list -> int
def poblacionMundialIndex(l):
	habitantes = 0
	for pais in l:
		habitantes += pais.habitantes
	return habitantes				

assert poblacionMundialIndex(listaPaisesIndex) == 900000
